﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Linq;
using System.Text;
using System.Diagnostics;
using System.Windows.Forms;

namespace PowerAmpDemoNS
{
    public partial class PowerAmpDemoProgram
    {
        // Test Procedures
        public int wcdmaTest()
        {
            // Configure variables for WCDMA Standard
            string testWaveform = wcdmaArb;
            string testName = "WCDMA Test";
            vsag.setupParameters("WCDMA");
            dataLog.tstName = "WCDMA";

            dataLog.addResultsHeader(testName);
            //Start Test timer
            sw.Reset();
            sw.Start();

            // External trigger and short waveforms will improve and repeatability, but will increase test times
            bool useExtTrig = true;

            // Configure for External Trigger on ARB Wrap signal
            vsag.configVsaTrigger("EXTERNAL");

            if (testEvm)
            {
                // Setup the VSG and VSA for waveform, band frequency and power level
                // If we are not measuring EVM, the waveform length can be ~ 1.2 ms for a 600 us ACPR acquisition
                // To measure EVM also, we need a slightly longer waveform
                vsag.setupVsgVsa(testWaveform, cellFreqs[0], targetPout, targetGain); //, true, 2.5e-3);
            }
            else
            {
                // Setup the VSG and VSA for waveform, band frequency and power level
                vsag.setupVsgVsa(testWaveform, cellFreqs[0], targetPout, targetGain, true);
            }

            // for WCDMA, set the scale factor to 0.5 for best ACPR
            vsag.setVsgIqScale(0.5, true); ;

            // Configure the EVM measurement
            if (testEvm)
                vsag.configWcdmaEvmMeas("MS", cellFreqs[0], targetPout);

            // Loop over Frequencies for Low Band
            for (int i = 0; i < cellFreqs.Length; i++)
            {
                dataLog.addResultsHeader("Frequency = " + (cellFreqs[i] / 1e6).ToString("0.0") +
                    " MHz, Output Power = " + targetPout.ToString("0.00") + " dBm");
                // Set VSG and VSA to test frequency
                vsag.setTestFreq(cellFreqs[i]);

                // Servo source until Pout is at correct value
                if (vsag.fftServo)
                    vsag.servoInputPowerFft(targetPout, poutMargin);
                else
                    vsag.servoInputPower(targetPout, poutMargin);

                if (testCurr)
                {
                    // Measure DC Current
                    dcSmu.measCurrent();
                }

                if (testAcpr)
                {
                    // Use the IVI Driver to Measure ACPR
                    if (vsag.fftAcpr)
                        vsag.measFftAcpr();
                    else
                        vsag.measStdAcpr();
                }

                if (testEvm)
                {
                    // Measure EVM with X-App
                    // Unlock receiver from driver before starting, lock receiver and update setup when complete
                    vsag.unlockVsa();
                    vsag.setXappFreq(cellFreqs[i]);
                    vsag.measWcdmaEvm();
                    vsag.lockVsa();

                    if (useExtTrig)
                    {
                        // Configure for External Trigger on ARB Wrap signal
                        vsag.configVsaTrigger("EXTERNAL");
                    }
                    vsag.setupVsa(cellFreqs[i], targetPout);
                }

                if (testHarms)
                {
                    // Measure Harmonics using Spectrum Method
#if M9393
                    bool[] harmsToMeas = new bool[numCellHarms];

                    for (int harmIdx = 0; harmIdx < numCellHarms; harmIdx++)
                    {
                        harmsToMeas[harmIdx] = true;
                    }
                    vsag.measSpecHarms2(harmsToMeas);
#else
                    vsag.measSpecHarms(true, true);
#endif
                }

 

                // Tests complete, setup for next test
                dataLog.nextTest();
            }
            // Put it back to immediate trigger
            // Configure for External Trigger on ARB Wrap signal
            vsag.configVsaTrigger("IMMEDIATE");

            // Update results and data log for end of test
            dataLog.addResultsFooter(testName, sw.ElapsedMilliseconds);
            return 0;
        }
    }
}